import gc
import sys
import config
import httpsearchclient

def print_conn(conn):
    for key in sorted(dir(conn)):
        if key.startswith('__'):
            continue
        print "%s=%s" % (str(key), str(getattr(conn, key)))
    print ""

def main():
    conf = config.ServerConfig('extsearch/audio/upper/audiouppersearch.cfg')
    client = httpsearchclient.HttpSearchClient(Script=conf.Collection.SearchSource.CgiSearchPrefix, Options=conf.Collection.SearchSource.Options)
    it = client.PossibleConnections(0)
    conn = it.Next()
    while conn:
        print conn.GroupDescr + '\t' + conn.SearchScript
        conn = it.Next()

if __name__ == '__main__':
    gc.set_debug(gc.DEBUG_LEAK)
    main()
