#!/usr/bin/env python
# -*- coding: utf-8 -*-

from yandex_inflector_python import Inflector
from yandex_inflector_python import FioInflector
from yandex_inflector_python import Pluralize
from yandex_inflector_python import Singularize


CASES = [
    "nom",  # именительный падеж (голова, сын, степь, сани, который)
    "gen",  # родительный падеж (головы, сына, степи, саней, которого)
    "dat",  # дательный падеж (голове, сыну, степи, саням, которому)
    "acc",  # винительный падеж (голову, сына, степь, сани, который/которого)
    "ins",  # творительный падеж (головой, сыном, степью, санями, которым)
    "abl",  # предложный падеж ([о] голове, сыне, степи, санях, котором)
]


def test():
    infl = Inflector("rus")
    for cs in CASES:
        print infl.Inflect(u"абракадабра", "sg,{cs}".format(cs=cs))

    fio_infl = FioInflector("rus")
    for cs in CASES:
        print fio_infl.Inflect(u"Мария Петровна Иванова", "f,{cs}".format(cs=cs))

    for n in [1, 2, 5, 27]:
        print u"%s %s" % (n, Pluralize(u"бакинский комиссар", n, 'ru'))

    print u"1 %s" % (Singularize(u"бакинских комиссаров", 27, 'ru'))


def main():
    test()


if __name__ == "__main__":
    main()
