#pragma once

#include "python_core.h"

#include <kernel/lemmer/core/language.h>

#include "python_wrappers.h"

#include <util/generic/typetraits.h>

#ifndef THISDLLNAME
#define THISDLLNAME lemmer_python_binding
#endif

#define _STR(name) #name
#define STR(name) _STR(name)
#define MODULE_NAME_STR STR(THISDLLNAME)

struct TLemmaInfo {
    // see https://docs.python.org/2/extending/newtypes.html
    // First fields in class has to be PyObject object, to mimic
    // PyObject_HEAD macro behaviour and is more safe then pure macro itself
    PyObject HEAD;

    PyObject* Lemma;
    PyObject* Language;
    PyObject* Form;
    PyObject* LexicalFeature;
    PyObject* FormFeature;

    typedef TSimpleSharedPtr<TWLemmaArray> TLemmas;
    TLemmas* Lemmata;
    const TYandexLemma* LemmaPtr;

    TCharCategory Flags;
    int RuleId;
    int Bastardness;
    int First;
    int Last;
    int FlexLen;
    double Weight;

    void Initialize();
    void Deinitialize();

    PyObject* Generate() const;
    PyObject* GenerateImpl() const;

    static const char* ClassName;
    static PyMethodDef Methods[];
    static PyMemberDef Members[];
    static PyTypeObject Type;

    static NPython::TPyObjPtr WrapLemma(const TLemmaInfo::TLemmas& lemmata, const TYandexLemma& lemma);
    static NPython::TPyObjPtr Wrap(const TLemmaInfo::TLemmas& lemmata);
};
static_assert(std::is_standard_layout<TLemmaInfo>::value, "TLemmaInfo has to be standard layout");
static_assert(offsetof(TLemmaInfo, HEAD) == 0, "PyObject field HEAD must be the first field in class");

TLemmaInfo* NewLemmaInfo();

void DeleteLemmaInfo(PyObject* lemmaInfo);
