#!/usr/bin/env /usr/local/bin/python
# -*- Encoding: windows-1251 -*-

import cgi
import codecs
import sys
import time
import urllib

import liblemmer_python_binding as lemmer

class CGILemmer:
    def __init__(self, query, output):
        self.query = query
        self.output = output

    def execute(self):
        self.output.write('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">')

        word = self.query.get("req", None)
        if word != None and len(word) > 0:
            word = word[0].strip()
        else:
            word = ""

        self.output.write(u"""
            <html><head>
                <title>lemmer-test</title>
                <meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
            </head>
            <form method="get">
                <table>
                    <tr>
                        <td>
                             
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <input type="text" name="req" size="50" style="width: 100%; padding:0; border:#808080 1px solid;" value=""")
        self.output.write(u"\"%s\"" % word)
        self.output.write(u""">
                        </td>
                        <td>
                            <input class="button" type="submit" value="">
                        </td>
                    </tr>
                </table>
            </form>
            <table>
                <tr>
                <td valign="top">
        """)

        if word != "":
            analyses = lemmer.AnalyzeWord(word)
            self.output.write("<i>%s</i><br/><br/>" % word)
            for ana in analyses:
                if ana.Bastardness & 1:
                    self.output.write("<b>Bastard lemma:</b> %s<br/>" % ana.Lemma)
                elif ana.Bastardness & 2:
                    self.output.write("<b>Sob lemma:</b> %s<br/>" % ana.Lemma)
                elif ana.Bastardness & 4:
                    self.output.write("<b>Prefixoid bastard lemma:</b> %s<br/>" % ana.Lemma)
                elif ana.Bastardness & 8:
                    self.output.write("<b>Foundling lemma:</b> %s<br/>" % ana.Lemma)
                else:
                    self.output.write("<b>Lemma:</b> %s<br/>" % ana.Lemma)
                self.output.write("<b>Lemma features:</b> %s<br/>" % ", ".join(ana.LexicalFeature))
                self.output.write("<b>Inflection features:</b> %s<br/>" % " | ".join(map(lambda x: ", ".join(x), ana.FormFeature)))
                self.output.write("<b>Language:</b> %s<br/>" % ana.Language)
                temp = []
                for (form, gramms) in ana.Generate():
                    temp.append("%s {%s}" % (form, " | ".join(gramms)))
                self.output.write("<b>Paradigm:</b><br/>&nbsp;&nbsp;&nbsp;&nbsp;%s<br/>" % "<br/>&nbsp;&nbsp;&nbsp;&nbsp;".join(temp).replace(",", ", "))
                self.output.write("<br/>")

        self.output.write(u"""
            </td><td width="500" align="right" valign="top">
                <table border="1" style="font-size: 15px;">
                <tr><td>A</td><td></td><td> , , </td></tr>

                <tr><td>ADV</td><td></td><td>, </td></tr>
                <tr><td>CONJ</td><td></td><td>, </td></tr>
                <tr><td>INTJ</td><td></td><td>, </td></tr>
                <tr><td>NUM</td><td></td><td>, , </td></tr>
                <tr><td>PART</td><td></td><td>, , </td></tr>

                <tr><td>PR</td><td></td><td>, </td></tr>
                <tr><td>S</td><td></td><td>, , , </td></tr>
                <tr><td>V</td><td></td><td>, </td></tr>
                <tr><td>ANUM</td><td>-</td><td>, , </td></tr>
                <tr><td>APRO</td><td>-</td><td>, </td></tr>

                <tr><td>ADVPRO</td><td> </td><td>, </td></tr>
                <tr><td>SPRO</td><td>-</td><td>, </td></tr>
                <tr><td>COM</td><td>  &mdash;  </td><td> ( ),  ()</td></tr>
                <tr><td>ART</td><td></td><td>the, a</td></tr>

                <tr><td></td><td> </td><td>&nbsp;</td></tr>
                <tr><td></td><td> </td><td>&nbsp;</td></tr>
                <tr><td>AOT_</td><td>  (     &nbsp; )</td><td></td></tr>
                <tr><td></td><td> ;  &nbsp; ""</td><td> </td></tr>

                <tr><td></td><td> </td><td>, , </td></tr>
                <tr><td></td><td>  (, &nbsp;&nbsp;   &nbsp;)</td><td>, , </td></tr>
                <tr><td></td><td> </td><td>, , , , </td></tr>
                <tr><td></td><td> </td><td>, , , , </td></tr>

                <tr><td></td><td> </td><td>, , , , </td></tr>
                <tr><td></td><td> </td><td>, , , , /</td></tr>
                <tr><td></td><td> </td><td>, , , , </td></tr>
                <tr><td></td><td> </td><td>[] , , , , </td></tr>
                <tr><td></td><td>  </td><td> </td></tr>

                <tr><td></td><td>  </td><td> </td></tr>
                <tr><td></td><td> </td><td>, </td></tr>
                <tr><td></td><td> </td><td>, , </td></tr>
                <tr><td></td><td></td><td></td></tr>
                <tr><td></td><td></td><td></td></tr>

                <tr><td></td><td></td><td></td></tr>
                <tr><td></td><td> </td><td>, , </td></tr>
                <tr><td></td><td> </td><td></td></tr>
                <tr><td>AOT_</td><td> </td><td>, , </td></tr>
                <tr><td></td><td> </td><td>, , </td></tr>

                <tr><td></td><td> </td><td>, , , </td></tr>
                <tr><td></td><td> </td><td></td></tr>
                <tr><td></td><td> </td><td></td></tr>
                <tr><td></td><td> </td><td></td></tr>
                <tr><td>1-</td><td> </td><td></td></tr>

                <tr><td>2-</td><td> </td><td></td></tr>
                <tr><td>3-</td><td> </td><td></td></tr>
                <tr><td></td><td> &nbsp;</td><td>, </td></tr>
                <tr><td></td><td> &nbsp;</td><td>, </td></tr>
                <tr><td></td><td> &nbsp;</td><td>, </td></tr>

                <tr><td></td><td>  &nbsp; ,    <br />
                  &nbsp; ,   &nbsp;</td><td>, </td></tr>
                <tr><td></td><td> &nbsp;</td><td>, </td></tr>
                <tr><td></td><td> &nbsp;</td><td>, </td></tr>

                <tr><td></td><td>    &nbsp;:</td><td>, </td></tr>
                <tr><td>AOT_</td><td> </td><td></td></tr>
                <tr><td></td><td>     &nbsp;:</td><td>, </td></tr>
                <tr><td></td><td> </td><td></td></tr>

                <tr><td></td><td> </td><td></td></tr>
                <tr><td></td><td></td><td>, , </td></tr>
                <tr><td></td><td></td><td>, , </td></tr>
                <tr><td>reserved</td><td>, &nbsp;    </td><td></td></tr>

                <tr><td></td><td></td><td></td></tr>
                <tr><td>obsc</td><td></td><td>&nbsp;</td></tr>
                <tr><td></td><td></td><td></td></tr>
                <tr><td></td><td> </td><td></td></tr>
                <tr><td></td><td></td><td></td></tr>

                <tr><td></td><td></td><td></td></tr>
                <tr><td></td><td> </td><td></td></tr>
                <tr><td></td><td> </td><td>&nbsp;</td></tr>
                <tr><td></td><td></td><td>&nbsp;</td></tr>
                <tr><td></td><td></td><td>&nbsp;</td></tr>

                <tr><td>AOT_</td><td> </td><td></td></tr>
                </table>
            </td></tr></table>
        """)

def main():
    sys.stdout.write('Content-Type: text/html\r\n\r\n')

    out = codecs.getwriter("windows-1251")(sys.stdout, 'xmlcharrefreplace')

    query = cgi.parse(keep_blank_values = True)

    for (key, val) in query.items():
        l = []
        for el in val:
            l.append(codecs.getdecoder("windows-1251")(urllib.unquote(el))[0])
        query[key] = l

    request = CGILemmer(query, out)
    request.execute()

if __name__ == "__main__":
    main()
