import os
import yatest.common


def get_correct_env():
    env = os.environ.copy()
    env["BINARY_ROOT_PATH"] = yatest.common.build_path()
    return env


def test_analyze():
    command = [
        yatest.common.source_path("bindings/python/lemmer/example.py"),
        "-t",
        "-f", "simple",
    ]

    inp_path = yatest.common.data_path("lemmer/commonwords.txt")
    out_path = "analyze.out"

    with open(inp_path) as inp:
        with open(out_path, "w") as out:
            yatest.common.py_execute(command, stdout=out, stdin=inp, env=get_correct_env())

    return yatest.common.canonical_file(out_path)


def test_paradigm():
    command = [
        yatest.common.source_path("bindings/python/lemmer/example-paradigm.py"),
        "-t",
    ]

    inp_path = yatest.common.data_path("lemmer/paradigmwords.txt")
    out_path = "paradigm.out"

    with open(inp_path) as inp:
        with open(out_path, "w") as out:
            yatest.common.py_execute(command, stdout=out, stdin=inp, env=get_correct_env())

    return yatest.common.canonical_file(out_path)
