# coding: utf-8
#!/usr/bin/env python

import yandex_misspell


def TestEditDistance():
    # Examples from dict/misspell/errmodels/lib/ut/str_dist_ut.cpp
    examples = [
        { "from": u"угодия", "to": u"угодья", "true_value": 3 },
        { "from": u"варение", "to": u"варенье", "true_value": 5 },
        { "from": u"п1чему", "to": u"почему", "true_value": 13 },
        { "from": u"по4та", "to": u"почта", "true_value": 13 },
        { "from": u"погрущик", "to": u"погрузчик", "true_value": 6 },
        { "from": u"3айцев", "to": u"Зайцев", "true_value": 13 },
        { "from": u"0дноклассники", "to": u"Одноклассники", "true_value": 13 },
        { "from": u"неет", "to": u"нет", "true_value": 7 },
        { "from": u"смененным", "to": u"сменным", "true_value": 10 },
        { "from": u"металлома", "to": u"металлолома", "true_value": 11 },
        { "from": u"однокласс7ики", "to": u"одноклассники", "true_value": 13 },
        { "from": u"одноклассн7ики", "to": u"одноклассники", "true_value": 18 },
        { "from": u"warcrsft3", "to": u"warcrsft", "true_value": 30 },
        { "from": u"щастье", "to": u"счастье", "true_value": 6 },
        { "from": u"диавол", "to": u"дьявол", "true_value": 7 },
        { "from": u"немой", "to": u"мой", "true_value": 30 },
        { "from": u"ненадо", "to": u"надо", "true_value": 30 },
        { "from": u"гороцкой", "to": u"городской", "true_value": 6 },
        { "from": u"кунцкамера", "to": u"кунсткамера", "true_value": 3 },
        { "from": u"йандекс", "to": u"яндекс", "true_value": 11 },
        { "from": u"еркширский", "to": u"йоркширский", "true_value": 6 },
        { "from": u"научится", "to": u"научиться", "true_value": 1 },
        { "from": u"посчитать", "to": u"посещать", "true_value": 33 },
        { "from": u"потомская", "to": u"потоцкая", "true_value": 17 },
        { "from": u"мущина",  "to": u"мужчина",  "true_value": 8 },
        { "from": u"женчина", "to": u"женщина",  "true_value": 5 },
        { "from": u"женсчина", "to": u"женщина", "true_value": 4 },
        { "from": u"ёлки",    "to": u"елки",     "true_value": 0 },
        { "from": u"елки",    "to": u"ёлки",     "true_value": 0 },
        { "from": u"естровел", "to": u"острове", "true_value": 19 },
        { "from": u"естровел", "to": u"эстровэл", "true_value": 6 },
        { "from": u"дамские", "to": u"томские", "true_value": 12 },
        { "from": u"фирьы",   "to": u"фирмы",   "true_value": 10 },
        { "from": u"майя",    "to": u"мая",      "true_value": 2 },
        { "from": u"майями",  "to": u"майами",   "true_value": 1 },
        { "from": u"майа",    "to": u"майя",     "true_value": 1 },
        { "from": u"мышки",   "to": u"мишки",    "true_value": 6 },
        { "from": u"нарсицизм", "to": u"нарциссизм", "true_value": 13 },
        { "from": u"начес",   "to": u"начос",    "true_value": 1 },
        { "from": u"начос",   "to": u"начес",    "true_value": 1 },
        { "from": u"петь",    "to": u"пить",     "true_value": 7 },
        { "from": u"прожажа", "to": u"продажа", "true_value": 10 },
        { "from": u"тросо",   "to": u"торо",    "true_value": 22 },
        { "from": u"травмопункт", "to": u"травмпункт", "true_value": 8 },
    ]

    ed = yandex_misspell.EditDistance("ru")
    for ex in examples:
        value = ed.Calculate(ex["from"], ex["to"])
        print(value, ex["from"], ex["to"], value == ex["true_value"])

def TestTransfemeDistance():
    examples = [
        {"from": u"поивеь", "to": u"привет", "true_value": 8.624 },
    ]

    td = yandex_misspell.TransfemeDistance("transfemes", "ru")
    for ex in examples:
        value = round(td.Calculate(ex["from"], ex["to"]), 3)
        print(value, ex["from"], ex["to"], value == ex["true_value"])

def TestNormalize():
    examples = [
        {"text": u"ёлка", "lang": "ru", "true_value": u"елка"},
        {"text": u"Azərbaycan", "lang": "az", "true_value": u"azerbaycan"},
        {"text": u"işdə", "lang": "az", "true_value": u"isde"},
        {"text": u"abcdefghijklmnopqrstuvxyzçəğıöşü", "lang": "az", "true_value": u"abcdefghijklmnopqrstuvxyzcegiosu"},
    ]

    for ex in examples:
        normalized = yandex_misspell.Normalize(lang=ex["lang"], text=ex["text"])
        print(normalized, ex["text"], normalized == ex["true_value"])

if __name__ == "__main__":
    TestEditDistance()
    TestTransfemeDistance()
    TestNormalize()
