#!/usr/bin/env python2.7
#coding: utf-8

import os

from bindings.python.queryrec_lib import yandex_queryrec


def TestOld(text, tld):
    yandex_queryrec.SetTLD(tld)
    recognizer = yandex_queryrec.CreateTQueryRecognizer(
        os.path.expanduser("~/data/queryrec.dict"), 
        os.path.expanduser("~/data/queryrec.weights")
    )
    old_langs = recognizer.recognize(unicode(text, "utf-8"))
    new_langs = recognizer.recognizeEx(unicode(text, "utf-8"), tld)
    assert old_langs == new_langs, "old languages: {0}; new languages: {1}".format(old_langs, new_langs)


if __name__ == "__main__":
    TestOld("блондинка", "ru")
    TestOld("блондинка", "ua")
    TestOld("pazartesi", "tr")
    TestOld("pazartesi", "en")
