#!/usr/bin/env python2.7
import _seinfo

def Test(url):
    se = _seinfo.GetSEInfo(url)
    print "URL: {0}; searching_url: {1}".format(url, bool(se))
    if se:
        print "\tEngine:{0}; Type:{1}; Request:{2}; Flags:{3}".format(se.EngineName, se.Type, se.Request, se.Flags)
        print "\t" + "; ".join("{k}:{v}".format(k=key, v=(1 if getattr(se, key)() else 0)) for key in \
            ("IsWeb", "IsImage", "IsVideo", "IsLocal", "IsSearch", "IsEmail", "IsSocial", "IsSerpAdv", "IsWebAdv", "IsAdvert")
        )


if __name__ == "__main__":
    Test("http://yandex.ru/yandsearch?text=nokia")
    Test("https://www.google.ru/search?ie=UTF-8&hl=ru&q=nokia")
    Test("http://my.at.yandex-team.ru")
    Test("http://www.google.com.tr/url?sa=t&rct=j&q=&esrc=s&frm=1&source=web&cd=1&ved=0CCkQFjAA&url=http%3A%2F%2Fwww.hdrokettubem.biz%2FRokettube%2F&ei=Rt9KUo3WFdKw4QSY54H4DA&usg=AFQjCNH1mijFwfLn7HvebAiYqq3NfJu6EQ&bvm=bv.53371865,d.bGE")
    print "possible flags:\n\t" + ", ".join("{0}={1}".format(k, getattr(_seinfo, k)) for k in dir(_seinfo) if k.startswith("SF_"))
