#include <library/cpp/pybind/typedesc.h>
#include <library/cpp/pybind/pod.h>
#include <kernel/seinfo/seinfo.h>

/*
 *  def GetSEInfo(url):
 *      """return TSEInfo structure about url if it's a search url or None"""
 *
 *  struct TSEInfo:
 *      EngineName
 *      Flags
 *      Type
 *      Request
 */

struct TSeInfoHolder {
    THolder<NSe::TInfo> Result;

    TSeInfoHolder(NSe::TInfo* result)
        : Result(result)
    {}
};

class TSeInfoTraits: public NPyBind::TPythonType<TSeInfoHolder, NSe::TInfo, TSeInfoTraits> {
private:
    typedef class NPyBind::TPythonType<TSeInfoHolder, NSe::TInfo, TSeInfoTraits> TParent;
    friend class NPyBind::TPythonType<TSeInfoHolder, NSe::TInfo, TSeInfoTraits>;
    TSeInfoTraits();
public:
    static NSe::TInfo* GetObject(const TSeInfoHolder& holder) {
        return holder.Result.Get();
    }
};


class TSeInfoAttrGetter: public NPyBind::TBaseAttrGetter<NSe::TInfo> {
public:
    bool GetAttr(PyObject* , const NSe::TInfo& self, const TString& attr, PyObject*& res) const override {
        if (attr == "EngineName"sv)
            res = NPyBind::BuildPyObject(NSe::GetSearchEngineDict()[self.Name]);
        else if (attr == "Type"sv)
            res = NPyBind::BuildPyObject(NSe::GetSearchTypeDict()[self.Type]);
        else if (attr == "Request"sv)
            res = NPyBind::BuildPyObject(self.Query);
        else if (attr == "Flags"sv)
            res = NPyBind::BuildPyObject(self.Flags);
        else
            res = nullptr;
        return res != nullptr;
    }
};

TSeInfoTraits::TSeInfoTraits()
    : TParent("_seinfo.TSeInfo", "seinfo result object")
{
    AddCaller("IsWeb", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsWeb));
    AddCaller("IsImage", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsImage));
    AddCaller("IsVideo", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsVideo));
    AddCaller("IsLocal", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsLocal));
    AddCaller("IsSearch", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsSearch));
    AddCaller("IsEmail", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsEmail));
    AddCaller("IsSocial", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsSocial));
    AddCaller("IsSerpAdv", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsSerpAdv));
    AddCaller("IsWebAdv", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsWebAdv));
    AddCaller("IsAdvert", NPyBind::CreateConstMethodCaller<NSe::TInfo>(&NSe::TInfo::IsAdvert));
    AddGetter("", new TSeInfoAttrGetter);
}

PyObject* GetSEInfo(PyObject* /*obj*/, PyObject* args) {
    try {
        TString url;
        if (!NPyBind::ExtractArgs(args, url))
            ythrow yexception() << "wrong parameters for GetSEInfo()";
        NSe::TInfo result = NSe::GetSeInfo(url);
        if (! IsEmpty(result)) {
            NPyBind::TPyObjectPtr ptr(TSeInfoTraits::Instance().CreatePyObject(new TSeInfoHolder(new NSe::TInfo(result))));
            return ptr.RefGet();
        }
        Py_RETURN_NONE;
    } catch (const std::exception& e) {
        PyErr_SetString(PyExc_RuntimeError, e.what());
    }
    return nullptr;
}

static PyMethodDef _SEInfoMethods[] = {
    {"GetSEInfo", GetSEInfo, METH_VARARGS, "returns TSEInfo structure (with fields: EngineName, Flags, Type, Request) about url if it's a search url or None"},
    {nullptr, nullptr, 0, nullptr}
};


PyMODINIT_FUNC init_seinfo() {
    PyObject* m = Py_InitModule("_seinfo", _SEInfoMethods);
    using namespace NSe;
    TVector<std::pair<ESearchFlags, TStringBuf> > searchFlagsNames;
    GetSearchFlagsDict().GetAllNames(searchFlagsNames);
    for (size_t i = 0; i < searchFlagsNames.size(); ++i) {
        if (PyModule_AddObject(m, ToString(searchFlagsNames[i].first).data(), NPyBind::BuildPyObject(searchFlagsNames[i].first)) != 0)
            ythrow yexception() << "_seinfo: can't register " << ToString(searchFlagsNames[i].first) << " constant";
    }
}

