import yandex_tokenizer


def test_tokenizer():
    assert yandex_tokenizer is not None
    assert yandex_tokenizer.tokenize(u'qwe rty') == [[['NLP_WORD', 'qwe'], ['qwe']], [['NLP_MISCTEXT', ' '], []], [['NLP_WORD', 'rty'], ['rty']]]
    assert yandex_tokenizer.tokenize(u'qwe rty', False) == [[['NLP_WORD', 'qwe'], ['qwe']], [['NLP_MISCTEXT', ' '], []], [['NLP_WORD', 'rty'], ['rty']]]
    assert yandex_tokenizer.tokenize(u'qwe rty', True) == [[['NLP_WORD', 'qwe'], ['qwe']], [['NLP_MISCTEXT', ' '], []], [['NLP_WORD', 'rty'], ['rty']]]

    assert yandex_tokenizer.tokenize(u'$100k') == [[['NLP_MARK', '$100k'], ['100', 'k']]]
    assert yandex_tokenizer.tokenize(u'$100k', False) == [[['NLP_MARK', '$100k'], ['100', 'k']]]
    assert yandex_tokenizer.tokenize(u'$100k', True) == [[['NLP_MISCTEXT', '$'], []], [['NLP_MARK', '100k'], ['100k']]]
