#!/usr/bin/env python

import argparse
import yt.wrapper as yt

def parse_args():
    parser = argparse.ArgumentParser(description='Filter unknown images with too many answers')
    parser.add_argument('--yt-proxy', default='hahn', help='YT proxy')
    parser.add_argument('--input-table', required=True, help='Input table path.')
    parser.add_argument('--output-table', required=True, help='Output table path.')
    parser.add_argument('--shows-threshold', required=True, type=int, help='Maximum number of answers.')
    parser.add_argument('--key-field-name', required=True, help='Name of the key column.')
    return parser.parse_args()

class Reducer(object):
    def __init__(self, shows_threshold, key_field_name):
        self.shows_threshold = shows_threshold
        self.key_field_name = key_field_name

    def __call__(self, key, records):
        i = 0
        for record in records:
            i += 1
            if i > self.shows_threshold:
                yield key
                return

def main():
    args = parse_args()

    yt.config["proxy"]["url"] = args.yt_proxy
    yt.run_map_reduce(None, Reducer(args.shows_threshold, args.key_field_name), args.input_table, args.output_table,
        reduce_by=[args.key_field_name])

if __name__ == '__main__':
    main()
