#!/usr/bin/env python
import argparse
import json
import libmxnet
import ocr_factors

def parse_args():
    parser = argparse.ArgumentParser(description='Add properties to formula')
    parser.add_argument('-m', '--min-total-answers', default=100, type=int, help='Min total answers for a picture to use it')
    parser.add_argument('-t', '--threshold', required=True, type=float, help='Threshold')
    parser.add_argument('-i', '--input-path', required=True, help='Path to formula')
    parser.add_argument('-o', '--output-path', help='Path to output formula (default overwrites input)')
    return parser.parse_args()

def main():
    args = parse_args()
    formula = libmxnet.TMXNetInfo(args.input_path)
    formula.SetProperty('factor-ids', json.dumps(ocr_factors.FACTOR_NAMES))
    formula.SetProperty('selected-threshold', str(args.threshold))
    formula.SetProperty('min-total-answers', str(args.min_total_answers))
    formula.Save(args.output_path or args.input_path)

if __name__ == '__main__':
    main()
