#include <library/cpp/testing/unittest/registar.h>
#include <util/charset/wide.h>
#include "captcha_check.h"

#define UNIT_ASSERT_DEFINED_AND(expr, expected) do { \
                                                    auto x = expr; \
                                                    UNIT_ASSERT(x.Defined()); \
                                                    UNIT_ASSERT(x.GetRef() == expected); \
                                                } while (0)


namespace NCaptchaServer {
    Y_UNIT_TEST_SUITE(CheckSimpleAnswer) {
        Y_UNIT_TEST(Simple) {
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("cat", "cat"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("cat2", "cat2"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("cat2", "cat3"), false);

            UNIT_ASSERT_DEFINED_AND(CheckAnswer("кот", "кот"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("кот2","кот2"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("кот2", "кот3"), false);
        }

        Y_UNIT_TEST(CutBadSymbols) {
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("кот._", "кот__ "), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("ко._!@?#$ %^&*()т", "к-_=+<>от"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("ко т", "ко.т  "), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("к1т", "кот"), false);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("кот", "ко1т"), false); // check digit
        }

        Y_UNIT_TEST(Translate) {
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("КОТ", "кот"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("кот", "к0т"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("Çat", "Cat"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("Çat", "Gat"), false);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("Çat.", "=Cat_"), true);
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("Çat.", "=at_"), false);
        }

        Y_UNIT_TEST(BadUtf) {
            TString badStr = "cat";
            for (int i = 0; i < 256; i++) {
                badStr += i;
            }
            UNIT_ASSERT_DEFINED_AND(CheckAnswer("cat", badStr), false);
        }

        Y_UNIT_TEST(Empty) {
            UNIT_ASSERT(!CheckAnswer("correct answer", "").Defined());
            UNIT_ASSERT(!CheckAnswer("", "user answer").Defined());
        }

        Y_UNIT_TEST(Ocr) {
            UNIT_ASSERT(!CheckAnswer("(star #####_1558222672427811_1558180511587652_3812055446", "qwe").Defined());
        }
    }

    Y_UNIT_TEST_SUITE(TrimRep) {
        Y_UNIT_TEST(Simple) {
            UNIT_ASSERT(TString(TrimRep("cat", "cat", true)) == "cat");
            UNIT_ASSERT(TString(TrimRep("cat", "cat", false)) == "cat");
        }

        Y_UNIT_TEST(ShortRep) {
            UNIT_ASSERT(TString(TrimRep("cat", "cat кот", true)) == "cat");
            UNIT_ASSERT(TString(TrimRep("cat", "cat кот", false)) == "cat");
        }

        Y_UNIT_TEST(LongRep) {
            UNIT_ASSERT(TString(TrimRep("catкот", "cat", true)) == "cat");
            UNIT_ASSERT(TString(TrimRep("catкот", "кот", false)) == "кот");
        }
    }
}
