import tarfile
import os.path


def normalize_name(name):
    return os.path.normpath(name)


class Resources(object):
    def __init__(self, archive):
        self.items = {}
        tar = tarfile.open(fileobj=archive, mode='r|*')
        for tarinfo in tar:
            if not tarinfo.isreg():
                continue
            content = tar.extractfile(tarinfo).read()
            name = normalize_name(tarinfo.name)
            self.items[name] = content

    def get(self, name):
        return self.items[normalize_name(name)]
