#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
from datetime import datetime
import yt.wrapper as yt

def parse_args():
    parser = argparse.ArgumentParser(description='Add date to table')
    parser.add_argument('--yt-proxy', default='hahn', help='YT proxy')
    parser.add_argument('--mode', default='from_table', help='Source of date info.')
    parser.add_argument('--field-name', default='Upload_date', help='Name of the table field with date.')
    parser.add_argument('-i', '--input-table', required=True, help='Input table path.')
    parser.add_argument('-o', '--output-table', required=True, help='Output table path.')
    return parser.parse_args()

def main():
    args = parse_args()

    if args.mode == "from_table":
        raw_date = args.input_table.split('/')[-1]
        date = datetime.strptime(raw_date, "%Y_%m_%d")
    else:
        date = datetime.now()

    def mapper(record):
        record[args.field_name] = date.strftime("%Y-%m-%d")
        yield record

    yt.config["proxy"]["url"] = args.yt_proxy
    yt.config["auto_merge_output"]["action"] = "merge"

    yt.run_map(mapper, args.input_table, args.output_table)

if __name__ == "__main__":
    main()
