#!/usr/bin/env python

import argparse
import yt.wrapper as yt

def rename_type(s):
    new, old = s.split('=')
    return old, new

def parse_args():
    parser = argparse.ArgumentParser(description='Alter table columns')
    parser.add_argument('--yt-proxy', default='hahn', help='YT proxy')
    parser.add_argument('-i', '--input-table', required=True, help='Input table path.')
    parser.add_argument('-o', '--output-table', required=True, help='Output table path.')
    parser.add_argument('--rename', nargs='*', type=rename_type, help='Columns to rename (NEWNAME=OLDNAME)')
    parser.add_argument('--drop', nargs='*', help='Columns to drop')
    parser.add_argument('--memory-limit', type=int, default=1024**3, help='Memory limit for jobs')
    return parser.parse_args()

class Mapper(object):
    def __init__(self, rename, drop):
        self.rename = rename
        self.drop = drop

    def __call__(self, rec):
        for old, new in self.rename:
            if old in rec:
                rec[new] = rec[old]
                del rec[old]

        for col in self.drop:
            if col in rec:
                del rec[col]

        yield rec

def main():
    args = parse_args()

    yt.config["proxy"]["url"] = args.yt_proxy
    yt.run_map(Mapper(args.rename, args.drop), args.input_table, args.output_table, memory_limit=args.memory_limit)

if __name__ == '__main__':
    main()
