#!/usr/bin/env python

import argparse
from datetime import datetime

import yt.wrapper as yt

def parse_args():
    parser = argparse.ArgumentParser(description='Store current timestamp in a file')
    parser.add_argument('--yt-proxy', default='hahn', help='YT proxy')
    parser.add_argument('--input-table', required=True, help='Input table path.')
    parser.add_argument('--timestamp-file', required=True, help='File containing timestamp.')
    parser.add_argument('--timestamp-input-format', default='%Y%m%dT%H%M%S', help='Timestamp format.')
    parser.add_argument('--output-table-pattern', required=True, help='Output table pattern.')
    return parser.parse_args()

def main():
    args = parse_args()

    yt.config["proxy"]["url"] = args.yt_proxy
    strtimestamp = open(args.timestamp_file, 'r').read().strip()
    timestamp = datetime.strptime(strtimestamp, args.timestamp_input_format)
    output_table = timestamp.strftime(args.output_table_pattern)
    yt.run_merge(args.input_table, output_table)

if __name__ == '__main__':
    main()
