#!/usr/bin/env bash

basetype="$1"
basepath="$basetype.tar.gz"
token="$(cat token)"
description="CAPTCHA images for $basetype stack ($(date))"
resource_type="CAPTCHA_IMAGES_$(echo $basetype | tr '[:lower:]' '[:upper:]')"

ln "$2" "$basepath"
curl -vOJ 'http://proxy.sandbox.yandex-team.ru/last/SANDBOX_UPLOAD_SCRIPT'
chmod +x upload.sfx.py
./upload.sfx.py "$basepath" --owner=CAPTCHA --oauth-token="$token" --description="$description" --type="$resource_type" --dump upload_log

task_id=$(python -c 'import json; print json.load(open("upload_log"))["task"]["id"]')

if [ -z "$task_id" ]; then
    echo "Failed to extract task_id, aborting" >&2
    exit 1
fi

cat > "release_$basetype.body" <<-END_DATA
{
    "task_id": ${task_id},
    "type": "stable",
    "subject": "${description}"
}
END_DATA

echo "release.$basetype.body: $(cat "release_$basetype.body")" >&2
curl -H "Authorization: OAuth ${token}" "https://sandbox.yandex-team.ru/api/v1.0/release" --data @"release_$basetype.body"
