#!/usr/bin/env python

import argparse
from datetime import datetime

def parse_args():
    parser = argparse.ArgumentParser(description='Store current timestamp in a file')
    parser.add_argument('--format', default='%Y%m%dT%H%M%S', help='Timestamp format.')
    parser.add_argument('--output', required=True, help='Output file path.')
    return parser.parse_args()

def main():
    args = parse_args()
    timestamp = datetime.now().strftime(args.format)
    open(args.output, 'w').write(timestamp)

if __name__ == '__main__':
    main()
