#pragma once

#include "items_storage.h"
#include "config.h"
#include "stats.h"

#include <library/cpp/cache/cache.h>
#include <library/cpp/threading/rcu/rcu.h>

#include <util/generic/hash.h>
#include <util/system/mutex.h>
#include <util/system/rwlock.h>
#include <util/system/thread.h>
#include <util/system/event.h>

namespace NCaptchaServer {
    class TCaptchaCachingItemsStorage: public ICaptchaItemsStorage {
    public:
        TCaptchaCachingItemsStorage(const TCaptchaConfig& config, TCaptchaStats& stats, ICaptchaItemsStorage* slave);

        NThreading::TFuture<bool> LoadItemData(const TCaptchaItemKey& key, TString& data) override;
        void LoadIndex(TCaptchaItemsIndex& index) override;
        TCaptchaItemHeader LoadRandomItemHeader(TStringBuf type, IRng* rng) override;

        void UpdateIndex();

        ~TCaptchaCachingItemsStorage();

    private:
        static void* UpdateLoop(void* ptr);

    private:
        TCaptchaConfig Config;
        TCaptchaStats& Stats;
        THolder<ICaptchaItemsStorage> Slave;

        TRWMutex Mutex;
        TManualEvent StopEvent;
        TThread UpdaterThread;
        TInstant LastUpdate;

        using TIndexesMap = THashMap<TString, TCaptchaItemsIndex>;
        NThreading::TRcu<TIndexesMap> LastIndexes;
        TLRUCache<TCaptchaItemKey, TString> DataCache;
        TMutex DataCacheMutex;
    };
}
