#pragma once

#include "config.h"
#include "handler.h"
#include "items_storage.h"
#include "session_storage.h"
#include "stats.h"

namespace NCaptchaServer {
    struct TVoiceCaptchaType {
        TString VoiceType;
        TString IntroUrl;
    };

    class ICaptchaType {
    public:
        virtual void InitSession(TStringBuf type, int checks, IRng* rng, TCaptchaSessionInfo& sessInfo) = 0;
        virtual bool ResponseGenerate(TStringBuf type, const TString& token, const TCaptchaSessionInfo& sessInfo, const TRequestInfo& reqInfo, THttpResponse& response) = 0;
        virtual NThreading::TFuture<THttpResponse> HandleGetImage(TStringBuf type, const TCaptchaSessionInfo& sessInfo, const TRequestInfo& reqInfo) = 0;
        virtual bool CheckAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TStringBuf userAnswer) = 0;
        virtual bool GetAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TString& answer) = 0;
        virtual void PrepareLoggedUserAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TString& userAnswer) = 0;
        virtual ~ICaptchaType() {
        }

        void InitSession(TStringBuf type, int checks, TCaptchaSessionInfo& sessInfo) {
            TDefaultRng rng;
            InitSession(type, checks, &rng, sessInfo);
        }
    };

    class TCaptchaTypeSimple: public ICaptchaType {
    public:
        TCaptchaTypeSimple(const TCaptchaConfig& config, TCaptchaStats& stats, TCaptchaItemsStorageRouter& itemsStorageRouter, const TString& imageType)
            : Config(config)
            , Stats(stats)
            , ItemsStorageRouter(itemsStorageRouter)
            , ImageType(imageType)
        {
        }

        void InitSession(TStringBuf type, int checks, IRng* rng, TCaptchaSessionInfo& sessInfo) override;
        bool ResponseGenerate(TStringBuf type, const TString& token, const TCaptchaSessionInfo& sessInfo, const TRequestInfo& reqInfo, THttpResponse& response) override;
        NThreading::TFuture<THttpResponse> HandleGetImage(TStringBuf type, const TCaptchaSessionInfo& sessInfo, const TRequestInfo& reqInfo) override;
        bool CheckAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TStringBuf userAnswer) override;
        bool GetAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TString& answer) override;

        void PrepareLoggedUserAnswer(TStringBuf, const TCaptchaSessionInfo&, TString&) override;

    protected:
        const TCaptchaConfig& Config;
        TCaptchaStats& Stats;
        TCaptchaItemsStorageRouter& ItemsStorageRouter;
        TString ImageType;
    };

    TUtf16String CutBadSymbols(const TString&);
    bool CheckSimpleAnswer(TStringBuf correctAnswer, TStringBuf userAnswer);
}
