#pragma once

#include "captchatype.h"

namespace NCaptchaServer {
    class TCaptchaTypeLocalization: public ICaptchaType {
    public:
        TCaptchaTypeLocalization(
            const TCaptchaConfig& config,
            TCaptchaStats& stats,
            TCaptchaItemsStorageRouter& itemsStorageRouter,
            const TString& knownImageType,
            const TString& unknownImageType,
            double requiredIOU,
            bool userCellsMustIntersectWithAnswer);
        void InitSession(TStringBuf type, int checks, IRng* rng, TCaptchaSessionInfo& sessInfo) override;
        bool ResponseGenerate(TStringBuf type, const TString& token, const TCaptchaSessionInfo& sessInfo, const TRequestInfo& reqInfo, THttpResponse& response) override;
        NThreading::TFuture<THttpResponse> HandleGetImage(TStringBuf type, const TCaptchaSessionInfo& sessInfo, const TRequestInfo& reqInfo) override;
        bool CheckAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TStringBuf userAnswer) override;
        bool GetAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TString& answer) override;
        void PrepareLoggedUserAnswer(TStringBuf type, const TCaptchaSessionInfo& sessInfo, TString& userAnswer) override;

    private:
        const TCaptchaConfig& Config;
        TCaptchaStats& Stats;
        TCaptchaItemsStorageRouter& ItemsStorageRouter;
        TString KnownImageType;
        TString UnknownImageType;
        double RequiredIOU;
        bool UserCellsMustIntersectWithAnswer;
    };

}
