#include <library/cpp/testing/unittest/registar.h>
#include <util/charset/wide.h>
#include "captchatype.h"

namespace NCaptchaServer {
    Y_UNIT_TEST_SUITE(CheckSimpleAnswer) {
        Y_UNIT_TEST(Simple) {
            // correctAnswer userAnswer
            UNIT_ASSERT(CheckSimpleAnswer("cat", "cat"));
            UNIT_ASSERT(CheckSimpleAnswer("cat2", "cat2"));
            UNIT_ASSERT(!CheckSimpleAnswer("cat2", "cat3"));

            UNIT_ASSERT(CheckSimpleAnswer("кот", "кот"));
            UNIT_ASSERT(CheckSimpleAnswer("кот2", "кот2"));
            UNIT_ASSERT(!CheckSimpleAnswer("кот2", "кот3"));
        }

        Y_UNIT_TEST(CutBadSymbols) {
            UNIT_ASSERT(CheckSimpleAnswer("кот._", "кот__ "));
            UNIT_ASSERT(CheckSimpleAnswer("ко._!@?#$ %^&*()т", "к-_=+<>от"));
            UNIT_ASSERT(CheckSimpleAnswer("ко т", "ко.т  "));
            UNIT_ASSERT(!CheckSimpleAnswer("к1т", "кот"));
            UNIT_ASSERT(!CheckSimpleAnswer("кот", "ко1т")); // check digit
        }

        Y_UNIT_TEST(Translate) {
            UNIT_ASSERT(CheckSimpleAnswer("КОТ", "кот"));
            UNIT_ASSERT(CheckSimpleAnswer("кот", "к0т"));
            UNIT_ASSERT(CheckSimpleAnswer("Çat", "Cat"));
            UNIT_ASSERT(!CheckSimpleAnswer("Çat", "Gat"));
            UNIT_ASSERT(CheckSimpleAnswer("Çat.", "=Cat_"));
            UNIT_ASSERT(!CheckSimpleAnswer("Çat.", "=at_"));
        }

        Y_UNIT_TEST(BadUtf) {
            TString badStr = "cat";
            for (int i = 0; i < 256; i++) {
                badStr += i;
            }
            UNIT_ASSERT(!CheckSimpleAnswer("cat", badStr));
        }
    }
}
