#include "config.h"

#include <library/cpp/json/json_reader.h>
#include <library/cpp/protobuf/json/json2proto.h>

#include <util/stream/file.h>

namespace NCaptchaServer {
    TCaptchaConfig::TCaptchaConfig(const TFsPath& path) {
        NJson::TJsonValue json;
        TFileInput file(path);
        NJson::ReadJsonTree(&file, true, &json, true);
        NProtobufJson::Json2Proto(json, *this);
    }
}
