#pragma once

#include "items_storage.h"
#include "config.h"
#include "stats.h"

namespace NCaptchaServer {
    class TCaptchaFallbackItemsStorage: public ICaptchaItemsStorage {
    public:
        TCaptchaFallbackItemsStorage(const TCaptchaConfig& config, TCaptchaStats& stats);

        NThreading::TFuture<bool> LoadItemData(const TCaptchaItemKey& key, TString& data) override;
        void LoadIndex(TCaptchaItemsIndex& index) override;
        void LoadIndex(TStringBuf type, TCaptchaItemsIndex& index) override;

    private:
        void PrepareItems(const THashMap<TString, TString>& archive);

    private:
        struct TItem {
            TString Data;
            NJson::TJsonValue Metadata;

            TItem(const TString& data, const NJson::TJsonValue& metadata)
                : Data(data)
                , Metadata(metadata)
            {
            }
        };

    private:
        TCaptchaConfig Config;
        TCaptchaStats& Stats;
        THashMap<TString, THashMap<TCaptchaItemKey, TItem>> Items;
    };
}
