#pragma once

#include "session_storage_router.h"

namespace NCaptchaServer {
    enum class ECaptchaFallbackActivator {
        ConfigOrFallbackHandler = 0,
        RequestRateMonitor,
        ModeFileWatcher,
        Count
    };

    class TCaptchaFallbackStateAggregator {
    public:
        TCaptchaFallbackStateAggregator(TCaptchaSessionStorageRouter& storageRouter)
            : StorageRouter(storageRouter)
        {
        }

        void SetFallbackState(ECaptchaFallbackActivator activator, bool state) {
            States[static_cast<size_t>(activator)] = state;
            bool aggregatedState = false;

            for (bool state : States) {
                if (state) {
                    aggregatedState = true;
                    break;
                }
            }

            StorageRouter.SetFallbackState(aggregatedState);
        }

    private:
        TCaptchaSessionStorageRouter& StorageRouter;
        bool States[static_cast<size_t>(ECaptchaFallbackActivator::Count)] = {false};
    };
}
