#pragma once

#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>
#include <library/cpp/http/cookies/lctable.h>
#include <library/cpp/threading/future/future.h>

#include <util/network/address.h>
#include <sys/socket.h>

namespace NCaptchaServer {
    struct TRequestInfo {
        explicit TRequestInfo(THttpInput& httpInput, const TSocket& socket, bool local)
            : HttpInput(httpInput)
            , Local(local)
        {
            NAddr::TOpaqueAddr remote;
            TStringOutput so(RemoteHost);
            int error = getpeername(socket, remote.MutableAddr(), remote.LenPtr());
            if (error != 0) {
                ythrow yexception() << "getpeername returned " << error;
            }
            NAddr::PrintHost(so, remote);

            for (const auto& it : httpInput.Headers()) {
                if (AsciiEqualsIgnoreCase(it.Name(), "X-Forwarded-For-Y")) {
                    RealIp = it.Value();
                    break;
                }
            }
        }

        THttpInput& HttpInput;
        bool Local;
        TString RemoteHost;
        TString RealIp;
        TString Token;
    };

    class IHandler {
    public:
        virtual NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqinfo) = 0;

        virtual ~IHandler() {
        }
    };
}
