#pragma once

#include "handler.h"
#include "config.h"
#include "http_server.h"

namespace NCaptchaServer {
    class THandlerAnswer: public IHandler {
    public:
        THandlerAnswer(const TCaptchaConfig& config, TCaptchaHttpServer* server, TCaptchaSessionStorageRouter& sessionStorageRouter)
            : Config(config)
            , Server(server)
            , SessionStorageRouter(sessionStorageRouter)
        {
        }

        NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqInfo) override;

    private:
        TCaptchaConfig Config;
        TCaptchaHttpServer* Server;
        TCaptchaSessionStorageRouter& SessionStorageRouter;
    };
}
