#pragma once

#include "handler.h"
#include "config.h"
#include "http_server.h"

namespace NCaptchaServer {
    struct THandlerCheckState {
        bool Error = false;
        TStringBuf ErrorMessage;
        TStringBuf ErrorDesc;

        TStringBuf Status;
        TStringBuf LogStatus;

        TString Token;
        TString Rep;
        TString Ip;
        bool Json = false;

        TString RemoteHost;
        bool Oldstyle = false;

        TString Answer;
        TString VoiceAnswer;
        NJson::TJsonValue SessionMetadata;
        TString Client;
    };

    class THandlerCheck: public IHandler {
    public:
        THandlerCheck(const TCaptchaConfig& config, TCaptchaHttpServer* server, TCaptchaSessionStorageRouter& sessionStorageRouter, TLog& checksLog)
            : Config(config)
            , Server(server)
            , SessionStorageRouter(sessionStorageRouter)
            , ChecksLog(checksLog)
        {
        }

        NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqInfo) override;

    private:
        bool CheckAnswer(const TCaptchaSessionInfo& sessInfo, TAtomicSharedPtr<THandlerCheckState> statePtr);
        void MakeLogEntry(TStringBuf status, const TString& token, const TCaptchaSessionInfo& sessInfo, TStringBuf userAnswer);
        void PushStats(bool status, const TCaptchaSessionInfo& sessInfo);

    private:
        const TCaptchaConfig& Config;
        TCaptchaHttpServer* Server;
        TCaptchaSessionStorageRouter& SessionStorageRouter;
        TLog& ChecksLog;
    };
}
