#include "handler_generate.h"

#include "items_storage.h"
#include "fallback_session_storage.h"
#include "session_storage.h"

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/json/writer/json.h>
#include <library/cpp/logger/global/global.h>

#include <library/cpp/cgiparam/cgiparam.h>

namespace NCaptchaServer {
    void RewriteOcrType(TString& type) {
        if (type == "ocr") {
            type = "txt_v0";
        } else if (type == "ocr_en") {
            type = "txt_v0_en";
        }
    }

    NThreading::TFuture<THttpResponse> THandlerGenerate::HandleRequest(TRequestInfo& reqInfo) {
        TParsedHttpFull req(reqInfo.HttpInput.FirstLine());
        TCgiParameters params(req.Cgi);

        TString type = params.Get("type");
        RewriteOcrType(type); // насильно переводим клиентов, которые не хотят переезжать с ocr
        TString vtype = params.Get("vtype");

        TAtomicSharedPtr<TCaptchaSessionInfo> sessionInfoPtr(new TCaptchaSessionInfo);
        auto cont = [this, type, sessionInfoPtr, &reqInfo](const NThreading::TFuture<TString>& ftoken) {
            reqInfo.Token = ftoken.GetValue();
            THttpResponse response;
            if (Server->GetCaptchaType(type)->ResponseGenerate(type, reqInfo.Token, *sessionInfoPtr, reqInfo, response)) {
                MakeLogEntry(reqInfo.Token, *sessionInfoPtr);
                Server->Stats.PushSignal(ETypeSegmentedSignals::RequestsGenerate, Server->GetCaptchaTypeName(type));
            }
            return response;
        };

        ICaptchaSessionStorage* sessionStorage = SessionStorageRouter.GetMainStorage();
        if (SessionStorageRouter.IsFallbackStorage(sessionStorage)) {
            Server->Stats.PushSignal(ESignals::StorageFallbackRequestsGenerate);
        }

        auto checks = FromStringWithDefault(params.Get("checks"), 1);
        if (checks < 1) {
            checks = 1;
        }
        TCaptchaSessionRequest request(type, vtype, checks, Now());
        return sessionStorage->CreateSession(request, *sessionInfoPtr).Apply(cont);
    }

    void THandlerGenerate::MakeLogEntry(const TString& token, const TCaptchaSessionInfo& sessInfo) {
        if (sessInfo.Fallback && !Config.GetFallback().GetEnableGenerateLog()) {
            return;
        }

        ICaptchaType* ctype = Server->GetCaptchaType(sessInfo.Type);

        TString line;
        TStringOutput so(line);
        NJsonWriter::TBuf json(NJsonWriter::HEM_UNSAFE, &so);

        TString metadataStr;
        TStringOutput metadataSo(metadataStr);
        metadataSo << sessInfo.Metadata;

        json.BeginObject();
        json.WriteKey("timestamp").WriteString(GetTimestamp());
        json.WriteKey("timezone").WriteString("+0000");
        json.WriteKey("KEY").WriteString(token);
        json.WriteKey("metadata").WriteString(metadataStr);
        json.WriteKey("version").WriteString("1");
        json.WriteKey("type").WriteString(sessInfo.Type);
        if (sessInfo.Fallback) {
            json.WriteKey("fallback").WriteString("true");
        }
        TString answer;
        if (ctype->GetAnswer(sessInfo.Type, sessInfo, answer)) {
            json.WriteKey("answer").WriteString(answer);
        }
        json.EndObject();
        so << Endl;

        GenerateLog << line;
    }
}
