#pragma once

#include "handler.h"
#include "config.h"
#include "http_server.h"

#include "items_storage.h"

namespace NCaptchaServer {
    class ICaptchaSessionStorage;

    class THandlerGenerate: public IHandler {
    public:
        THandlerGenerate(TCaptchaHttpServer* server, const TCaptchaConfig& config, TCaptchaSessionStorageRouter& sessionStorageRouter, TLog& generateLog)
            : Server(server)
            , Config(config)
            , SessionStorageRouter(sessionStorageRouter)
            , GenerateLog(generateLog)
        {
        }

        NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqInfo) override;

    private:
        void MakeLogEntry(const TString& token, const TCaptchaSessionInfo& sessInfo);

    private:
        TCaptchaHttpServer* Server;
        TCaptchaConfig Config;
        TCaptchaSessionStorageRouter& SessionStorageRouter;
        TLog& GenerateLog;
    };
}
