#pragma once

#include "handler.h"
#include "config.h"
#include "http_server.h"

namespace NCaptchaServer {
    class THandlerImage: public IHandler {
    public:
        THandlerImage(TCaptchaHttpServer* server, TCaptchaSessionStorageRouter& sessionStorageRouter)
            : Server(server)
            , SessionStorageRouter(sessionStorageRouter)
        {
        }

        NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqInfo) override;

    private:
        TCaptchaHttpServer* Server;
        TCaptchaSessionStorageRouter& SessionStorageRouter;
    };
}
