#include "handler_randomitem.h"

#include "items_storage.h"

#include <library/cpp/http/misc/parsed_request.h>

#include <library/cpp/cgiparam/cgiparam.h>

namespace NCaptchaServer {
    NThreading::TFuture<THttpResponse> THandlerRandomItem::HandleRequest(TRequestInfo& reqInfo) {
        TParsedHttpFull req(reqInfo.HttpInput.FirstLine());
        TCgiParameters params(req.Cgi);

        TString itemType = params.Get("itemtype");

        ICaptchaItemsStorage* itemsStorage = ItemsStorageRouter.GetStorage(params.Get("storage"));
        TCaptchaItemHeader itemHeader = itemsStorage->LoadRandomItemHeader(itemType);
        const auto& contentType = itemHeader.Metadata.GetMapSafe().at("content_type").GetStringSafe();
        TAtomicSharedPtr<TString> contentPtr(new TString());

        auto cont = [contentType, contentPtr](const NThreading::TFuture<bool>& result) {
            if (!result.GetValue()) {
                return THttpResponse(HTTP_INTERNAL_SERVER_ERROR);
            }

            THttpResponse response(HTTP_OK);
            response.SetContent(*contentPtr);
            response.AddHeader("Content-Type", contentType);
            return response;
        };

        return itemsStorage->LoadItemData(itemHeader.Key, *contentPtr).Apply(cont);
    }
}
