#include "handler_static.h"

#include <library/cpp/http/misc/parsed_request.h>

#include <util/generic/xrange.h>
#include <util/stream/file.h>
#include <library/cpp/cgiparam/cgiparam.h>

namespace NCaptchaServer {
    static void LoadContent(const TFsPath& path, TString& sink) {
        TFileInput file(path);
        TStringOutput so(sink);
        TransferData(&file, &so);
    }

    THandlerStatic::THandlerStatic(const TCaptchaConfig& config) {
        for (auto i : xrange(config.StaticFilesSize())) {
            const auto& info = config.GetStaticFiles(i);
            auto& resource = Resources[info.GetResource()];
            LoadContent(info.GetPath(), resource.Content);
            resource.ContentType = info.GetContentType();
        }
    }

    NThreading::TFuture<THttpResponse> THandlerStatic::HandleRequest(TRequestInfo& reqInfo) {
        TParsedHttpFull req(reqInfo.HttpInput.FirstLine());
        TCgiParameters params(req.Cgi);

        TStringBuf path = req.Path;
        path.SkipPrefix(TStringBuf("/static/"));
        auto resource = Resources.find(path);
        if (resource == Resources.end()) {
            return NThreading::MakeFuture(THttpResponse(HTTP_NOT_FOUND));
        }

        THttpResponse response;
        response.AddHeader("Content-Type", resource->second.ContentType);
        response.SetContent(resource->second.Content);
        return NThreading::MakeFuture(response);
    }
}
