#pragma once

#include "handler.h"
#include "config.h"
#include "http_server.h"

#include <util/generic/hash.h>

namespace NCaptchaServer {
    struct TStaticResource {
        TString ContentType;
        TString Content;
    };

    class THandlerStatic: public IHandler {
    public:
        THandlerStatic(const TCaptchaConfig& config);

        NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqInfo) override;

    private:
        THashMap<TString, TStaticResource> Resources;
    };
}
