#pragma once

#include "handler.h"
#include "config.h"
#include "http_server.h"

namespace NCaptchaServer {
    class THandlerVoice: public IHandler {
    public:
        THandlerVoice(TCaptchaHttpServer* server, TCaptchaItemsStorageRouter& itemsStorageRouter, TCaptchaSessionStorageRouter& sessionStorageRouter)
            : Server(server)
            , ItemsStorageRouter(itemsStorageRouter)
            , SessionStorageRouter(sessionStorageRouter)
        {
        }

        NThreading::TFuture<THttpResponse> HandleRequest(TRequestInfo& reqInfo) override;

    private:
        TCaptchaHttpServer* Server;
        TCaptchaItemsStorageRouter& ItemsStorageRouter;
        TCaptchaSessionStorageRouter& SessionStorageRouter;
    };
}
