#include "helpers.h"

#include "captchatype.h"
#include "captchatype_ocr.h"
#include "captchatype_localization.h"

namespace NCaptchaServer {
    THolder<ICaptchaType> MakeCaptchaType(const TCaptchaConfig& config, TCaptchaStats& stats, TCaptchaItemsStorageRouter& itemsStorageRouter, const TCaptchaConfig::TCaptchaTypeOptions& options) {
        if (options.GetType() == "simple") {
            TString imageType = options.GetSimpleCaptchaOptions().GetImageType();
            return MakeHolder<TCaptchaTypeSimple>(config, stats, itemsStorageRouter, imageType);
        } else if (options.GetType() == "ocr") {
            TString imageType = options.GetSimpleCaptchaOptions().GetImageType();
            return MakeHolder<TCaptchaTypeOcr>(config, stats, itemsStorageRouter, imageType);
        } else if (options.GetType() == "localization") {
            TString knownImageType = options.GetLocalizationCaptchaOptions().GetKnownImageType();
            TString unknownImageType = options.GetLocalizationCaptchaOptions().GetUnknownImageType();
            double requiredIOU = options.GetLocalizationCaptchaOptions().GetRequiredIOU();
            bool userCellsMustIntersectWithAnswer = options.GetLocalizationCaptchaOptions().GetUserCellsMustIntersectWithAnswer();
            Y_VERIFY(knownImageType != "" && unknownImageType != "");
            return MakeHolder<TCaptchaTypeLocalization>(config, stats, itemsStorageRouter, knownImageType, unknownImageType, requiredIOU, userCellsMustIntersectWithAnswer);
        } else {
            Y_VERIFY(false && "Unknown captcha type");
        }
    }

    static char RandomAlNum(IRng* rng) {
        Y_ASSERT(rng);
        static const char allowed[] = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        return allowed[rng->RandomNumber(sizeof(allowed) - 1)];
    }

    void RandomAlNumString(IRng* rng, size_t length, TStringOutput& output) {
        Y_ASSERT(rng);
        for (auto i : xrange(length)) {
            Y_UNUSED(i);
            output << RandomAlNum(rng);
        }
    }

    TString BuildToken(IRng* rng, char storageTag, TStringBuf prefix, size_t length) {
        TString result;
        TStringOutput so(result);

        so << '0' << storageTag << prefix;
        RandomAlNumString(rng, length - result.length(), so);

        Y_ASSERT(result.length() == length);

        return result;
    }
}
