#pragma once

#include "config.h"
#include "fallback_state_aggregator.h"
#include "handler.h"
#include "items_storage_router.h"
#include "request_rate_monitor.h"
#include "session_factory.h"
#include "session_storage_router.h"
#include "stats.h"
#include "captchatype.h"

#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>
#include <library/cpp/logger/log.h>

#include <util/generic/hash.h>
#include <util/system/rwlock.h>

namespace NCaptchaServer {
    class TCaptchaHttpServer: public THttpServer, public THttpServer::ICallBack {
    public:
        TCaptchaHttpServer(const TCaptchaConfig& config, TCaptchaStats& stats, TCaptchaSessionFactory& sessionFactory, TCaptchaItemsStorageRouter& itemsStorageRouter, TCaptchaSessionStorageRouter& sessionStorageRouter, TCaptchaFallbackStateAggregator& fallbackStateAggregator);
        TClientRequest* CreateClient() override;

        TStringBuf HandlerNameFromPath(TStringBuf path) const {
            if (path[0] != '/')
                return TStringBuf{};

            while (path) {
                auto handler = Handlers.find(path);
                if (handler != Handlers.end()) {
                    return path;
                }
                TStringBuf rest;
                path.RSplit('/', path, rest);
            }

            return TStringBuf{};
        }

        void ReopenLogs();

        TStringBuf GetCaptchaTypeName(TStringBuf name) {
            return SessionFactory.GetCaptchaTypeName(name);
        }

        ICaptchaType* GetCaptchaType(TStringBuf name) {
            return SessionFactory.GetCaptchaType(name);
        }

        const TVoiceCaptchaType& GetVoiceCaptchaType(TStringBuf name) {
            return SessionFactory.GetVoiceCaptchaType(name);
        }

    public:
        TCaptchaStats& Stats;
        TCaptchaSessionFactory& SessionFactory;

    private:
        friend class TCaptchaRequestReplier;

        TRWMutex ConfigMutex;
        TCaptchaConfig Config;
        THashMap<TString, THolder<IHandler>> Handlers;
        THashMap<TString, THolder<ICaptchaType>> CaptchaTypes;
        THashMap<TString, TVoiceCaptchaType> VoiceCaptchaTypes;

        TCaptchaItemsStorageRouter& ItemsStorageRouter;
        TCaptchaSessionStorageRouter& SessionStorageRouter;
        TCaptchaFallbackStateAggregator& FallbackStateAggregator;
        TCaptchaRequestRateMonitor RequestRateMonitor;

        TLog ChecksLog;
        TLog GenerateLog;
        THolder<TLog> AccessLog;
    };
}
