#include "items_storage.h"

#include <util/random/random.h>

namespace NCaptchaServer {
    TCaptchaItemKey::TCaptchaItemKey(const NJson::TJsonValue& jsonVal) {
        const auto& mapVal = jsonVal.GetMapSafe();
        Version = mapVal.at("version").GetStringSafe();
        Type = mapVal.at("type").GetStringSafe();
        Id = mapVal.at("id").GetStringSafe();
    }

    NJson::TJsonValue TCaptchaItemKey::AsJsonValue() const {
        NJson::TJsonValue json{NJson::JSON_MAP};
        json["version"] = Version;
        json["type"] = Type;
        json["id"] = Id;
        return json;
    }

    void ICaptchaItemsStorage::LoadIndex(TStringBuf type, TCaptchaItemsIndex& index) {
        index.clear();

        TCaptchaItemsIndex full;
        LoadIndex(full);

        for (const auto& item : full) {
            if (item.Key.Type == type) {
                index.push_back(item);
            }
        }
    }

    TCaptchaItemHeader ICaptchaItemsStorage::LoadRandomItemHeader(TStringBuf type, IRng* rng) {
        Y_ASSERT(rng);
        TCaptchaItemsIndex index;
        LoadIndex(type, index);
        return index[rng->RandomNumber(index.size())];
    }
}
