#include "items_storage_router.h"

#include <util/string/ascii.h>
#include <util/string/cast.h>

namespace NCaptchaServer {
    void TCaptchaItemsStorageRouter::RegisterStorage(ECaptchaItemsStorageId id, ICaptchaItemsStorage* storage) {
        Y_ASSERT(id != ECaptchaItemsStorageId::Count);
        Storages[static_cast<size_t>(id)] = storage;
    }

    ICaptchaItemsStorage* TCaptchaItemsStorageRouter::GetStorage(TStringBuf str) {
        if (str.empty()) {
            return GetStorage(GetPreferredStorageId());
        }

        for (auto i : xrange(static_cast<size_t>(ECaptchaItemsStorageId::Count))) {
            ECaptchaItemsStorageId id = static_cast<ECaptchaItemsStorageId>(i);

            if (AsciiEqualsIgnoreCase(ToString(id), str)) {
                Y_ENSURE(Storages[i]);
                return Storages[i];
            }
        }

        ythrow yexception() << "Unknown storage: " << TString{str}.Quote() << Endl;
    }

    TCaptchaItemsStorageRouter::~TCaptchaItemsStorageRouter() {
        if (OwnStorages) {
            for (auto i : xrange(static_cast<size_t>(ECaptchaItemsStorageId::Count))) {
                if (Storages[i]) {
                    delete Storages[i];
                }
            }
        }
    }
}
