#pragma once

#include "items_storage.h"

#include <util/generic/xrange.h>

namespace NCaptchaServer {
    enum class ECaptchaItemsStorageId {
        Kikimr = 0,
        Fallback,
        Count
    };

    class TCaptchaItemsStorageRouter {
    public:
        TCaptchaItemsStorageRouter(bool ownStorages = true)
            : OwnStorages(ownStorages)
        {
            Zero(Storages);
        }

        void RegisterStorage(ECaptchaItemsStorageId id, ICaptchaItemsStorage* storage);

        ICaptchaItemsStorage* GetStorage(ECaptchaItemsStorageId id) {
            Y_ASSERT(id != ECaptchaItemsStorageId::Count);
            ICaptchaItemsStorage* result = Storages[static_cast<size_t>(id)];
            Y_ENSURE(result);
            return result;
        }

        bool HasStorage(ECaptchaItemsStorageId id) {
            Y_ASSERT(id != ECaptchaItemsStorageId::Count);
            return bool(Storages[static_cast<size_t>(id)]);
        }

        ECaptchaItemsStorageId GetPreferredStorageId() {
            if (HasStorage(ECaptchaItemsStorageId::Kikimr)) {
                return ECaptchaItemsStorageId::Kikimr;
            }
            if (HasStorage(ECaptchaItemsStorageId::Fallback)) {
                return ECaptchaItemsStorageId::Fallback;
            }
            ythrow yexception() << "No storages are registered";
        }

        ICaptchaItemsStorage* GetStorage(TStringBuf str);

        ~TCaptchaItemsStorageRouter();

    private:
        bool OwnStorages;
        ICaptchaItemsStorage* Storages[static_cast<size_t>(ECaptchaItemsStorageId::Count)];
    };
}
