#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/stream/str.h>
#include <util/string/cast.h>
#include <util/string/split.h>

namespace NCaptchaServer {
    struct TRectangle {
        double MinX, MinY, MaxX, MaxY;

        TRectangle() {
        }

        TRectangle(double minX, double minY, double maxX, double maxY)
            : MinX(minX)
            , MinY(minY)
            , MaxX(maxX)
            , MaxY(maxY)
        {
        }

        TString AsFlatString() const;
        static TRectangle FromFlatString(const TString& str);
    };

    struct TGrid {
        int X, Y;

        TGrid(int x, int y)
            : X(x)
            , Y(y)
        {
        }
    };

    using TResponseArray = TVector<int>;

    class TLocalizationChecker {
    public:
        TLocalizationChecker(const TRectangle& bbox, const TRectangle& answer, const TResponseArray& reply, const TGrid& grid);

        double IntersectOverUnion() const;
        bool AllUserCellsIntersectWithAnswer() const;

    private:
        const TResponseArray& Reply;
        double GridXStep;
        double GridYStep;
        TVector<TRectangle> GridBboxes;
        TRectangle BboxAnswerCropped;
    };
}
