#include <library/cpp/testing/unittest/registar.h>
#include "localization_checks.h"

namespace NCaptchaServer {
    Y_UNIT_TEST_SUITE(LocalizationChecks) {
        Y_UNIT_TEST(RectangleConversions) {
            TRectangle rect(0.25, 0.1, 0.8, 0.95);
            TRectangle rect2 = TRectangle::FromFlatString(rect.AsFlatString());

            UNIT_ASSERT_DOUBLES_EQUAL(rect.MinX, rect2.MinX, 0.0005);
            UNIT_ASSERT_DOUBLES_EQUAL(rect.MinY, rect2.MinY, 0.0005);
            UNIT_ASSERT_DOUBLES_EQUAL(rect.MaxX, rect2.MaxX, 0.0005);
            UNIT_ASSERT_DOUBLES_EQUAL(rect.MaxY, rect2.MaxY, 0.0005);
        }

        Y_UNIT_TEST(IntersectOverUnion) {
            auto iou1 = TLocalizationChecker(
                            TRectangle(0.2, 0.2, 0.5, 0.5),
                            TRectangle(0.3, 0.1, 0.7, 0.7),
                            {1, 2, 6, 9, 10},
                            TGrid(4, 4))
                            .IntersectOverUnion();

            auto iou2 = TLocalizationChecker(
                            TRectangle(0.0, 0.0, 1.0, 1.0),
                            TRectangle(0.25, 0.25, 0.75, 0.75),
                            {5, 6, 9, 10},
                            TGrid(4, 4))
                            .IntersectOverUnion();

            auto iou3 = TLocalizationChecker(
                            TRectangle(0.0, 0.0, 1.0, 1.0),
                            TRectangle(0.25, 0.25, 0.75, 0.75),
                            {6, 9},
                            TGrid(4, 4))
                            .IntersectOverUnion();

            auto iou4 = TLocalizationChecker(
                            TRectangle(0.0, 0.0, 1.0, 1.0),
                            TRectangle(0.25, 0.25, 0.75, 0.75),
                            {4, 5, 8, 9},
                            TGrid(4, 4))
                            .IntersectOverUnion();

            UNIT_ASSERT_DOUBLES_EQUAL(iou1, 0.382, 0.0005);
            UNIT_ASSERT_DOUBLES_EQUAL(iou2, 1.0, 0.0005);
            UNIT_ASSERT_DOUBLES_EQUAL(iou3, 0.5, 0.0005);
            UNIT_ASSERT_DOUBLES_EQUAL(iou4, 0.333, 0.0005);
        }

        Y_UNIT_TEST(AllUserCellsIntersectWithAnswer) {
            TRectangle bbox(0.1, 0.3, 0.5, 0.8);
            TRectangle answer(0.23, 0.45, 0.48, 0.75);
            UNIT_ASSERT(TLocalizationChecker(bbox, answer, {5, 6}, TGrid(4, 4)).AllUserCellsIntersectWithAnswer());
            UNIT_ASSERT(TLocalizationChecker(bbox, answer, {9}, TGrid(4, 4)).AllUserCellsIntersectWithAnswer());
            UNIT_ASSERT(!TLocalizationChecker(bbox, answer, {1}, TGrid(4, 4)).AllUserCellsIntersectWithAnswer());
            UNIT_ASSERT(!TLocalizationChecker(bbox, answer, {2, 4}, TGrid(4, 4)).AllUserCellsIntersectWithAnswer());
        }
    }
}
