#pragma once

#include "config.h"
#include "fallback_state_aggregator.h"

#include <util/generic/hash_set.h>
#include <util/system/thread.h>
#include <util/system/event.h>

namespace NCaptchaServer {
    class TCaptchaModeFileWatcher {
    public:
        TCaptchaModeFileWatcher(const TCaptchaConfig& config, TCaptchaFallbackStateAggregator& fallbackStateAggregator);
        ~TCaptchaModeFileWatcher();

    private:
        static void* PollLoop(void* ptr);
        void ReadFile();

    private:
        TCaptchaFallbackStateAggregator& FallbackStateAggregator;

        TString Path;
        TDuration PollInterval;

        THashSet<TString> DisableFallbackKeywords;
        THashSet<TString> EnableFallbackKeywords;

        bool LastFallbackState = false;

        TManualEvent StopEvent;
        TThread PollerThread;
    };
}
