#pragma once

#include <util/random/mersenne.h>
#include <util/random/random.h>

namespace NCaptchaServer {
    class IRng {
    public:
        virtual ui64 RandomNumber(ui64 max) = 0;
        virtual double RandomDouble() = 0;
    };

    class TDefaultRng: public IRng {
    public:
        ui64 RandomNumber(ui64 max) {
            return ::RandomNumber(max);
        }

        double RandomDouble() {
            return ::RandomNumber<double>();
        }
    };

    class TDeterministicRng: public IRng, private TMersenne<ui64> {
    public:
        TDeterministicRng(ui64 seed)
            : TMersenne<ui64>(seed)
        {
        }

        ui64 RandomNumber(ui64 max) {
            return Uniform(max);
        }

        double RandomDouble() {
            return GenRandReal2();
        }
    };
}
