#pragma once

#include "fallback_state_aggregator.h"

#include <util/system/event.h>
#include <util/system/thread.h>

namespace NCaptchaServer {
    class TCaptchaRequestRateMonitor {
    public:
        TCaptchaRequestRateMonitor(const TCaptchaConfig& config, TCaptchaFallbackStateAggregator& fallbackStateAggregator);
        ~TCaptchaRequestRateMonitor();

        void RegisterRequest() {
            AtomicIncrement(RequestsCounter);
        }

    private:
        enum class EState {
            Normal,
            ConfirmingFallbackActivation,
            FallbackActive,
            ConfirmingFallbackDeactivation
        };

    private:
        static void* CheckLoop(void* ptr);

        void CheckNormal(TAtomicBase requests);
        void CheckConfirmingFallbackActivation(TAtomicBase requests);
        void CheckFallbackActive(TAtomicBase requests);
        void CheckConfirmingFallbackDeactivation(TAtomicBase requests);

    private:
        TCaptchaFallbackStateAggregator& FallbackStateAggregator;

        bool Enabled;
        ui32 CheckPeriodMs;
        ui32 FallbackActivationRateLimit;
        ui32 FallbackActivationChecksRequired;
        ui32 FallbackDeactivationRateLimit;
        ui32 FallbackDeactivationChecksRequired;

        EState State = EState::Normal;
        TAtomic RequestsCounter = 0;
        TThread CheckerThread;
        TManualEvent StopEvent;
        TInstant LastCheck;

        ui32 ActivationChecksCounter = 0;
        ui32 DeactivationChecksCounter = 0;
    };
}
