#include "session_factory.h"

namespace NCaptchaServer {
    TCaptchaSessionFactory::TCaptchaSessionFactory(const TCaptchaConfig& config, TCaptchaStats& stats, TCaptchaItemsStorageRouter& itemsStorageRouter)
        : ItemsStorageRouter(itemsStorageRouter)
    {
        for (const auto& typedesc : config.GetCaptchaTypes()) {
            CaptchaTypes[typedesc.GetName()] = MakeCaptchaType(config, stats, itemsStorageRouter, typedesc);
        }

        for (const auto& typedesc : config.GetVoiceCaptchaTypes()) {
            VoiceCaptchaTypes[typedesc.GetName()].VoiceType = typedesc.GetVoiceType();
            VoiceCaptchaTypes[typedesc.GetName()].IntroUrl = typedesc.GetIntroUrl();
        }

        FillTypeAliases(config.GetCaptchaTypes(), CaptchaTypeAliases);
        FillTypeAliases(config.GetVoiceCaptchaTypes(), VoiceCaptchaTypeAliases);
    }

    void TCaptchaSessionFactory::MakeSession(const TCaptchaSessionRequest& request, ECaptchaItemsStorageId storage, IRng* rng, TCaptchaSessionInfo& result) {
        result.Type = request.Type;
        result.Timestamp = request.Timestamp;
        result.ItemsStorage = storage;

        ICaptchaItemsStorage* itemsStorage = ItemsStorageRouter.GetStorage(storage);

        const TVoiceCaptchaType& voiceCaptchaType = GetVoiceCaptchaType(request.VoiceType);
        TCaptchaItemHeader itemHeader = itemsStorage->LoadRandomItemHeader(voiceCaptchaType.VoiceType, rng);
        result.Metadata["voice_type"] = request.VoiceType;
        result.Metadata["voice_metadata"] = itemHeader.Metadata;
        result.Metadata["voice_key"] = itemHeader.Key.AsJsonValue();
        result.Metadata["voice_introurl"] = voiceCaptchaType.IntroUrl;

        GetCaptchaType(request.Type)->InitSession(TString(request.Type), request.Checks, rng, result);
    }
}
