#pragma once

#include "captchatype.h"
#include "config.h"
#include "helpers.h"
#include "session_storage.h"
#include "items_storage_router.h"

namespace NCaptchaServer {
    class TCaptchaSessionFactory {
    public:
        TCaptchaSessionFactory(const TCaptchaConfig& config, TCaptchaStats& stats, TCaptchaItemsStorageRouter& itemsStorageRouter);

        void MakeSession(const TCaptchaSessionRequest& request, ECaptchaItemsStorageId storage, IRng* rng, TCaptchaSessionInfo& result);
        void MakeSession(const TCaptchaSessionRequest& request, ECaptchaItemsStorageId storage, TCaptchaSessionInfo& result) {
            TDefaultRng rng;
            MakeSession(request, storage, &rng, result);
        }

        TStringBuf GetCaptchaTypeName(TStringBuf name) {
            return GetWithDefault(CaptchaTypeAliases, name);
        }

        ICaptchaType* GetCaptchaType(TStringBuf name) {
            return CaptchaTypes.at(GetCaptchaTypeName(name)).Get();
        }

        const TVoiceCaptchaType& GetVoiceCaptchaType(TStringBuf name) {
            const auto& alias = GetWithDefault(VoiceCaptchaTypeAliases, name);
            return VoiceCaptchaTypes.at(alias);
        }

    private:
        TCaptchaItemsStorageRouter& ItemsStorageRouter;

        THashMap<TString, THolder<ICaptchaType>> CaptchaTypes;
        THashMap<TString, TVoiceCaptchaType> VoiceCaptchaTypes;

        THashMap<TString, TString> CaptchaTypeAliases;
        THashMap<TString, TString> VoiceCaptchaTypeAliases;
    };
}
