LIBRARY()

OWNER(
    iskostarev
    g:antirobot
)

PEERDIR(
    contrib/libs/libarchive
    contrib/libs/protobuf
    library/cpp/cache
    library/cpp/cgiparam
    library/cpp/charset
    library/cpp/html/pcdata
    library/cpp/http/misc
    library/cpp/http/server
    library/cpp/json
    library/cpp/json/writer
    library/cpp/logger
    library/cpp/logger/global
    library/cpp/protobuf/json
    library/cpp/string_utils/base64
    library/cpp/threading/future
    library/cpp/threading/rcu
    library/cpp/unicode/utf8_iter
    library/cpp/unistat
    security/ant-secret/snooper/cpp/logger
    ydb/library/yql/public/udf
    ydb/library/yql/public/udf/service/exception_policy
)

SRCS(
    config.proto
    config.cpp
    http_server.cpp
    session_factory.cpp
    stats.cpp
    helpers.cpp
    handler_generate.cpp
    handler_image.cpp
    handler_voice.cpp
    handler_check.cpp
    handler_answer.cpp
    handler_static.cpp
    handler_randomitem.cpp
    items_storage.cpp
    items_storage_router.cpp
    caching_items_storage.cpp
    precaching_session_storage.cpp
    fallback_items_storage.cpp
    fallback_session_storage.cpp
    request_rate_monitor.cpp
    captchatype.cpp
    captchatype_ocr.cpp
    captchatype_localization.cpp
    localization_checks.cpp
    mode_file_watcher.cpp
)

GENERATE_ENUM_SERIALIZATION(stats.h)

GENERATE_ENUM_SERIALIZATION(items_storage_router.h)

END()
