#include "ydb_client.h"

#include <library/cpp/logger/global/global.h>

#include <util/folder/pathsplit.h>
#include <util/stream/file.h>
#include <util/string/strip.h>

namespace NCaptchaServer {
    static NYdb::TDriverConfig MakeYdbDriverConfig(const TYdbDatabaseOptions& options) {
        NYdb::TDriverConfig result;

        result.SetEndpoint(options.GetEndpoint());
        result.SetDatabase(options.GetName());

        if (options.GetSecurityTokenFile()) {
            TString token = Strip(TFileInput(options.GetSecurityTokenFile()).ReadAll());
            result.SetAuthToken(token);
        }

        return result;
    }

    static NYdb::NTable::TClientSettings MakeYdbClientSettings(const TYdbDatabaseOptions& options) {
        NYdb::NTable::TClientSettings result;
        NYdb::NTable::TSessionPoolSettings sessionPoolSettings;

        sessionPoolSettings.MaxActiveSessions(options.GetMaxActiveYdbSessions());

        result.SessionPoolSettings(sessionPoolSettings);
        return result;
    }

    TCaptchaYdbClient::TCaptchaYdbClient(const TYdbDatabaseOptions& options, TCaptchaStats& stats)
        : Stats(stats)
        , Driver(MakeYdbDriverConfig(options))
        , Client(Driver, MakeYdbClientSettings(options))
        , DatabaseName(options.GetName())
    {
    }

    NYdb::NTable::TTableClient& TCaptchaYdbClient::GetClient() {
        return Client;
    }

    const TString& TCaptchaYdbClient::GetDatabaseName() {
        return DatabaseName;
    }
}
